// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ bgCylinder.cpp ]		Auter : KENSUKE WATANABE
//														Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
// -------- -------- -------- -------- -------- -------- -------- --------
// CN[ht@C
// -------- -------- -------- -------- -------- -------- -------- --------
#include <math.h>
#include "main.h"
#include "manager.h"
#include "utility.h"
#include "sceneCylinder.h"
#include "effect3DPoly.h"
#include "bgCylinder.h"
#include "input.h"
#include "modeGame.h"
#include "texManager.h"
#include "renderer.h"
#include <random>

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CBgCylinder::Init(void)
{
	// 
	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));
	SetSize(D3DXVECTOR3(1.f, 1.f, 1.f));
	SetCol(0, 0, 0, 255);
	m_moveUV = D3DXVECTOR2(0.f, 0.f);
	m_strFilePass.clear();
}

//-----------------------------------------------------------------------------
// I
//-----------------------------------------------------------------------------
void CBgCylinder::Uninit(void)
{
	// eNX̏I
	CSceneCylinder::Uninit();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CBgCylinder::Update(void)
{
	int stacks = GetStacks();
	int slices = GetSlices();
	int r = GetR();		int g = GetG();
	int b = GetB();		int a = GetA();

	VERTEX_3D* pVtx;	// obt@bN
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);
	for (int cntSlices = 0; cntSlices <= slices; cntSlices++)
	{
		for (int cntStacks = 0; cntStacks <= stacks; cntStacks++)
		{
			// F
			pVtx[0].col = D3DCOLOR_RGBA(r, g, b, a);
			pVtx++;
		}
	}
	// bN̉
	m_pVtxBuffer->Unlock();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// |S`
// -------- -------- -------- -------- -------- -------- -------- --------
void CBgCylinder::Draw(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);						// Cg\It
	pDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);	// eNX`tľJԂݒ
	pDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);	// eNX`uľJԂݒ

																		// e̕`
	CSceneCylinder::Draw();

	// _[Xe[g̐ݒ߂
	pDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);	// eNX`tľJԂݒ
	pDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);	// eNX`uľJԂݒ
	pDevice->SetRenderState(D3DRS_LIGHTING, TRUE);						// Cg̕\Lɂ
}

//-----------------------------------------------------------------------------
// _쐬
//-----------------------------------------------------------------------------
HRESULT CBgCylinder::SetVtx(int stacks, int slices)
{
	LPDIRECT3DDEVICE9 pDevice = CManager::GetRenderer().GetDevice();

	float phi = (D3DX_PI * 2) / stacks;			// Ƃ̊px

	int numVtx = (slices + 1) * (stacks + 1);							// _
	int numIndex = ((stacks + 1) * 2 * slices) + (slices - 1) * 2;		// CfbNX(Op` + ѕ(kރ|S))
	SetStacks(stacks);
	SetSlices(slices);
	SetNumVtx(numVtx);
	SetNumIndex(numIndex);

	// _obt@쐬--------------------------------
	if (FAILED(pDevice->CreateVertexBuffer(sizeof(VERTEX_3D) * numVtx,
		D3DUSAGE_WRITEONLY, FVF_VERTEX_3D, D3DPOOL_MANAGED, &m_pVtxBuffer, nullptr)))
	{
		return E_FAIL;
	}
	VERTEX_3D* pVtx;	// obt@bN
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	// 1ubN̕ƍ
	D3DXVECTOR3 size = GetSize();

	// _̐ݒ
	float x, y, z;

	for (int cntSlices = 0; cntSlices <= slices; cntSlices++)
	{
		for (int cntStacks = 0; cntStacks <= stacks; cntStacks++)
		{
			// W
			x = cos(phi * cntStacks) * size.x,			// X
			y = cntSlices * size.y,						// Y
			z = sin(phi * cntStacks) * size.z;			// Z
			pVtx[0].pos = D3DXVECTOR3(x, y, z);
			// @
			pVtx[0].nom = D3DXVECTOR3(0.f, 1.f, 0.f);
			// F
			pVtx[0].col = D3DCOLOR_RGBA(0, 0, 0, 255);
			// eNX`W
			pVtx[0].tex = D3DXVECTOR2((1.f / stacks) * cntStacks, 1.f - ((1.f / slices) * cntSlices));
			pVtx++;
		}
	}
	// bN̉
	m_pVtxBuffer->Unlock();

	// CfbNXobt@쐬--------------------------------
	if (FAILED(pDevice->CreateIndexBuffer(
		sizeof(WORD) * numIndex,			// obt@
		D3DUSAGE_WRITEONLY,					// gptO
		D3DFMT_INDEX16,						// Kvȃobt@
		D3DPOOL_MANAGED,					// ̊Ǘ@
		&m_pIdxBuffer,
		nullptr)))
	{
		return E_FAIL;
	}

	WORD *pIdx;			// obt@bN
	m_pIdxBuffer->Lock(0, 0, (void**)&pIdx, 0);

	int nCnt = 0;
	for (int nCntY = 0; nCntY < slices; nCntY++)
	{
		if (nCntY != 0)	// ԏ߂łȂ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY + (stacks));
			nCnt++;
		}
		// 2_ł(㉺)
		pIdx[nCnt] = static_cast<WORD>((stacks + 1) * (nCntY + 1));
		nCnt++;
		pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY);
		nCnt++;

		for (int nCntX = 0; nCntX < stacks; nCntX++)
		{
			// 2_ł(㉺)
			pIdx[nCnt] = static_cast<WORD>(((stacks + 1) * (nCntY + 1)) + (nCntX + 1));
			nCnt++;
			pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY + (nCntX + 1));
			nCnt++;
		}
		if (nCntY != slices - 1)	// ŌłȂ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>(stacks + (nCntY * (stacks)));
			nCnt++;
		}
	}

	//bN̉
	m_pIdxBuffer->Unlock();

	return NOERROR;
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CBgCylinder *CBgCylinder::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &size, const std::string &strFilePass, int createBoxFlame)
{
	assert(createBoxFlame > 0 && "createBoxFlame̒l0ȉł");

	// CBgCylinder̐
	CBgCylinder *pSceneCylinder;
	pSceneCylinder = new CBgCylinder(1);
	pSceneCylinder->Init();

	pSceneCylinder->SetPos(pos);
	pSceneCylinder->SetRot(rot);
	pSceneCylinder->SetSize(size);
	pSceneCylinder->m_strFilePass = strFilePass;
	pSceneCylinder->SetCol(255, 255, 255, 255);

	// _ݒ菈
	pSceneCylinder->SetVtx(32, 1);

	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(strFilePass);

	return pSceneCylinder;
}